program Turnyras;
const CMax  = 100;
      CDuom = 'U2duom.txt';
      CRez  = 'U2rez.txt';
type
    TEil = string[15];                      // Komandos pavadinimui - 15 simboliu
    // Iraso elementas
    TZiogai = record
        Komanda :TEil;                      // KOmandos pavadinimas
        ziogai_tsk:integer;                 // KOmandos "Ziogai" taskai
        varzovu_tsk:integer;                // Varzovu taskai
        skirt:integer;                      // (ne)Laimetu varzybu tasku skirtumas
    end;

    // Irasu masyvas
    TMas = array[1..CMax] of TZiogai;
    
var
    n:integer;                              // Rungtyniu skaicius
    Z:TMas;                                 // Ziogai rungtyniu sarasas
    m:integer;                              // Rungtyniu skaicius, per kurias imesta maziausiai tasku
    Min:TMas;                               // Rungtynes per kurias imesta maziausiai tasku
    d:integer;                              // Rungtyniu skaicius, laimejo didziausiu skirtumu
    Did:TMas;                               // Rungtynes per kurias laimejo didziausiu skirtumu


procedure Skaityti;
var F:text;
    i:integer;
Begin
      Assign(F,CDuom);
      Reset(F);
      ReadLn(F,n);
      for i := 1 to n do with Z[i] do
        ReadLn(F,Komanda,ziogai_tsk,varzovu_tsk)
end;

function RastiMin:integer;
var i,min:integer;
Begin
      min := Z[1].ziogai_tsk;    // Minimumas - pirmas elementas masyve
      for i := 1 to n do with Z[i] do
        if min > ziogai_tsk then min := ziogai_tsk;
      RastiMin := min;
end;

procedure Maziausi;
var i:integer;
Begin
     m:= 0;
     for i := 1 to n do
      if Z[i].ziogai_tsk = RastiMin then
        Begin
            m := m + 1;
            Min[m] := Z[i];
        end;
end;

function MaxSkirt:integer;
var i,max:integer;
Begin
      max := Z[1].ziogai_tsk - Z[1].varzovu_tsk ;
      for i := 1 to n do with Z[i] do
       Begin
        skirt := ziogai_tsk - varzovu_tsk;
        // Jeigu varzybos laimetos
        if skirt > 0 then
          if skirt > max then max := skirt;
       end;
      MaxSkirt := max;
end;

procedure Didziausi;
var i:integer;
Begin
     d:= 0;
     for i := 1 to n do
      if Z[i].skirt = MaxSkirt then
        Begin
            d := d + 1;
            Did[d] := Z[i];
        end;
end;

function Suma:integer;
var i,s:integer;
Begin
       s := 0;
       for i:= 1 to n do with Z[i] do
         s := s + ziogai_tsk;
       Suma := s;
end;

function Vid_Taskai:real;
Begin
      if n <> 0 then Vid_Taskai := Suma / n
                else Vid_Taskai := 0.0;
end;

procedure Spausdinti;
var F:text;
    i:integer;
Begin
   Assign(F,CRez);
   Rewrite(F);
   for i := 1 to m do with Min[i] do
     writeln(F,Komanda,ziogai_tsk:4,varzovu_tsk:4);
   for i := 1 to d do with Did[i] do
     writeln(F,Komanda,skirt:4);
   writeln(F,Vid_Taskai:4:2);
   writeln(F,Suma);
   Close(F);
end;
    
{-------------------------------Pagrindin programa----------------------------}
begin
  Skaityti;
  Maziausi;
  Didziausi;
  Spausdinti;
  Readln;
end.
